#include "dlc.h"
#include "sdcard/spi.h"

void dlc_init(void){
    //soft UART on pin 9
    TX_SET;     //idle high
    TRISACLR=_LATA_LATA2_MASK;        

	//SPI inited by backpack, set up CS here
    SDCS=1;
	SDCS_TRIS=0;
    
    //38400Hz timer interrupt
    T1CONbits.ON=0;     //reset T1
    T1CONbits.TCKPS=0;  //1:1 prescaler
    T1CONbits.TCS=0;    //internal source
    PR1=_XTAL_FREQ/AUDIO_SAMPLE_RATE;
    TMR1 = 0;           //reset
    IFS0bits.T1IF=0;    //clear flag
    IEC0bits.T1IE=1;    //enable
    IPC1bits.T1IP=1;    //priority 1
    T1CONbits.ON=1;     //T1 on
    
    //Audio PWMs
    //lock
    SYSKEY = 0;                 // force lock
    SYSKEY = 0xAA996655;        // unlock sequence
    SYSKEY = 0x556699AA;        //  
    //OC2 is pin 5/PWM1B/RB1
    OC2CON=0;       //reset
    OC2CON=6;       //PWM, no fault pin    
    T2CON=0;        //shut down
    PR2=256;        //so that we can use 8-bit data
    //T2CON=96;       //PS=64 => 2.4kHz
    T2CON=0;        //PS=1 => 156kHz
    //T2CON=16;        //PS=2 => 78kHz
    //T2CON=32;       //PS=4 => 39kHz
    T2CONSET=32768; //on
    OC2RS=127;     //test
    OC2CONSET=32768;//enable
    RPB1R=5;        //assign OC2 to pin 5

    //OC4 is PIN 24/PWM2B/RB13
    OC4CON=0;
    OC4CON=6;       //PWM, no fault pin    
    OC4RS=127;     //test
    OC4CONSET=32768;//enable
    RPB13R=5;        //assign OC4 to pin 24

    SYSKEY = 0;                 // force lock
    INTCONbits.MVEC=1;          //multi mode interrupts
    __builtin_enable_interrupts();    

}

long parse_word(unsigned char first, unsigned char second){ //returns 'time' in ms
  int i;
  switch(second){
    case 0: for(i=0;i<32;i++){lamps[i]=0;}  return 0;  //0x00 0x00 = all off        //save time, only 32 lamps
    case 1: return first+1;      //delay for x+1 millis
    case 2: return (first+1)*4;  //delay for (x+1)*4 millis
    case 3: return (first+1)*16; //delay for x+1 millis
    default:
      switch(second>>2){
        case 1: for(i=0;i<8;i++){lamps[i+(second&3)*8]=(first&(1<<i))?255:0;} return 0;    //set states of set
        case 2: for(i=0;i<8;i++){if((first&(1<<i))){lamps[i+(second&3)*8]=0;}} return 0;  //turn off selected in set
        case 3: for(i=0;i<8;i++){if((first&(1<<i))){lamps[i+(second&3)*8]=255;}} return 0;  //turn on selected in set
        case 4: lamps[first&31]=255; lamps[(second*8+first/32)&31]=255; return 0;                  //turn on 2 lights
        case 5: lamps[first&31]=0; lamps[(second*8+first/32)&31]=0; return 0;                      //turn off 2 lights
        case 6: lamps[first&31]=255; lamps[(second*8+first/32)&31]=0; return 0;                    //turn 1 on and 1 off
        case 7: lamps[first&31]=255-lamps[first&31]; lamps[(second*8+first/32)&31]=255-lamps[(second*8+first/32)&31]; return 0;  //invert 2 lights
        default:
          switch(second>>5){
            case 1: lamps[second & 31]=first;  return 0;    //set one lamp
            case 2:  rampSteps[second & 31] = 255 - lamps[second & 31]; rampTime[second & 31] = first+1;return 0;  //ramp up over t  
            case 3:  rampSteps[second & 31] = 0 - lamps[second & 31]; rampTime[second & 31] = first+1;return 0;  //ramp down over t  
            case 4:  rampSteps[second & 31] = 255 - lamps[second & 31]; rampTime[second & 31] = (first+1)*4;return 0;  //ramp up over t*4  
            case 5:  rampSteps[second & 31] = 0 - lamps[second & 31]; rampTime[second & 31] = (first+1)*4;return 0;  //ramp down over t*4  
            case 6:  rampSteps[second & 31] = 255 - lamps[second & 31]; rampTime[second & 31] = (first+1)*16;return 0;  //ramp up over t*16
            case 7:  rampSteps[second & 31] = 0 - lamps[second & 31]; rampTime[second & 31] = (first+1)*16;return 0;  //ramp down over t*16 
          }
      }  
  }
  return 0;    
}

long parse_word_no_action(unsigned char first, unsigned char second){ //returns 'time' in ms
  int i;
  switch(second){
    case 1: return first+1;      //delay for x+1 millis
    case 2: return (first+1)*4;  //delay for (x+1)*4 millis
    case 3: return (first+1)*16; //delay for x+1 millis
    default: return 0;
  }
  return 0;    
}


void checkRamps(long tm){
  int i;
  int s;    //temp steps
  long t;
  for(i=0;i<32;i++){        //save time by only checking actual lamps
      t=lamps[i];
      if(rampSteps[i]!=0){
        if(rampTime[i]<=tm){    //finish, also catches div/0
          t=t+rampSteps[i];
          rampSteps[i]=0;
          rampTime[i]=0;
        }else{
          s=(((long)(tm)*(long)(rampSteps[i]))/(long)(rampTime[i]));
          t=t+s;
          rampSteps[i]=rampSteps[i]-s;
          rampTime[i]=rampTime[i]-tm;        
        }
    }
    //catch overflow
    if(t<0){t=0;}
    if(t>255){t=255;}
    lamps[i]=t;
  }
}

void __ISR(_TIMER_1_VECTOR, IPL3SOFT) Timer1Handler(void){
    //handler for DLC data
    static int rCounter=0;
    long rTemp=0;
    static long statusCtr=0;
    unsigned char first;
    unsigned char second;  //for sequence parsing
    unsigned char seqd[2];
    unsigned char j;
    int n,b,c;    //byte number, bit (0-9), current data byte
    //first item to minimise jitter
    IFS0bits.T1IF=0;  //clear flag
    rCounter++;
    if(DLC_state){
        if(DLC_state<26){
            TX_CLR;                     //break (25)
        }else if(DLC_state<31){
            TX_SET;                     //mark after break (5)
        }else{
            n=(DLC_state-31)/10;
            b=(DLC_state-31)%10;
            //process here:
            c=DLC_data[n];    //byte of interest
            if(b==0){TX_CLR;}   //start bit
            else if(b==9){TX_SET;}//stop bit
            else if(c&(1<<(b-1))){TX_SET;}else{TX_CLR;}
            if(n>LAMPS){
                rTemp=(rCounter*1000)/AUDIO_SAMPLE_RATE;
                rCounter=0;
                if(DLC_run){
                    DLC_state=1;      //restart
                    //sample here to avoid jitter on output data
                    if(DLC_seq_state){
                        tmr=tmr+rTemp;
                        while((tmr>seqtmr)&&(DLC_seq_state)){       //set state up to expected at current time
                            for(j=0;j<2;j++){
                                seqd[j]=seqBuffer[seqBufferInUse][seqBufferPtr];
                                seqBufferPtr++;
                                if(seqBufferPtr>=seqBufferBytes[seqBufferInUse]){
                                    seqBufferPtr=0;
                                    seqBufferBytes[seqBufferInUse]=0;       //empty
                                    seqBufferInUse++;
                                    if(seqBufferInUse>=BUFFERCOUNT){
                                        seqBufferInUse=0;
                                    }
                                    if(seqBufferBytes[seqBufferInUse]==0){
                                        //run out of data
                                        tmr=0;
                                        DLC_seq_state=0;
                                        seqBufferInUse=0;       //reset
                                        seqBufferPtr=0;
                                        //break;                  //end while
                                    }
                                }
                            }
                            seqtmr=seqtmr+parse_word(seqd[0],seqd[1]);
                        }
                        checkRamps(rTemp);
                    }
                }else{
                    DLC_state=-1;TX_SET;//stop, set idle (-1 gets incremented to 0)
                }
            }
        }        
        DLC_state++;
    }
    //Handler for WAV data, second
    if(WAV_state){
        char d[8]={0,0,0,0,0,0,0,0};        //buffer
        char r=0;   //bytes to read
        wav_offset=wav_offset+wav_sample_rate;
        while(wav_offset>0){                //get 0,1 or more samples
            wav_offset=wav_offset-AUDIO_SAMPLE_RATE;
            r=0;
            while(r<wav_bytes_per_sample){
                d[r]=wavBuffer[wavBufferInUse][wavBufferPtr];
                wavBufferPtr++;
                if(wavBufferPtr>=wavBufferBytes[wavBufferInUse]){
                    wavBufferPtr=0;
                    wavBufferBytes[wavBufferInUse]=0;       //empty
                    wavBufferInUse++;
                    if(wavBufferInUse>=BUFFERCOUNT){
                        wavBufferInUse=0;
                    }
                    if(wavBufferBytes[wavBufferInUse]==0){
                        //run out of data
                        WAV_state=0;
                        OC2RS=(128)&0xFF;   //set at quiescent
                        OC4RS=(128)&0xFF;
                        wavBufferInUse=0;       //reset
                        wavBufferPtr=0;
                    }
                }
                r++;
            }
            //output samples
            if(wav_signed){
                OC2RS=(d[wav_right_offset]^0x80)&0xFF;
                OC4RS=(d[wav_left_offset]^0x80)&0xFF;
            }else{
                OC2RS=(d[wav_right_offset]&0xFF);
                OC4RS=(d[wav_left_offset]&0xFF);                
            }
        }        
    }
    statusCtr++;
    if(statusCtr>1700){        //arbitrary slow update for debugging
        statusCtr=0;
/*
        uart_printi(DLC_data[1]);
        uart_print(" ");
        uart_printi(DLC_data[2]);
        uart_print(" ");
        uart_printi(DLC_data[3]);
        uart_print(" ");
        uart_printi(DLC_data[4]);
        uart_print(" ");
        uart_printi(DLC_state);
        uart_print("\r\n");
*/    
    }
    //if(IFS0bits.T1IF){uart_print("E\r\n");}      //ISR has taken too long

    //test tones
    //OC2RS=(OC2RS+1)&0xFF;
    //OC4RS=(OC4RS+1)&0xFF;
    //tmr++;
}

